new (class newsApp extends AdminBase {
    constructor() {
        super();
        this.init();
    }

    init() {
        const newsApp = new Vue({
            el: "#news-table",
            data: {
                total: 0,
                list: {}
            },
            created: function () {
                this.get_list();
            },
            methods: {
                get_list: function (page = 1, title = '') {
                    let that = this;
                    title = encodeURIComponent(title);
                    $.getJSON(`/news/news?title=${title}&page=${page}&is_ajax=1`, function (data) {
                        that.total = data.total;
                        that.list = data.list;
                        AdminBase.pagination($('#page-wrap'), {
                            total: data.total,
                            current_page: data.current_page,
                            last_page: data.last_page,
                            callback: that.get_list,
                        });
                    });
                },
                del: (id) => {
                    if (!id) {
                        return AdminBase.fail('错误操作！');
                    }
                    return AdminBase.warn('确认删除此条文档吗?', () => {
                            this.delete(id);
                        }
                    );
                },
                publish: (id) => {
                    return AdminBase.warn('确认发布此条文档吗?', () => {
                        this.publish(id);
                    });
                },
                rollback: (id) => {
                    return AdminBase.warn('确认撤回此条文档吗?', () => {
                        this.rollback(id);
                    });
                }
            }
        });
        $('.content').off().on('click', '.title-search', () => {
            let val = AdminBase.tools().trim($('.title-input').val());
            return val.length && newsApp.get_list(1, val);
        })
    }

    delete(id) {
        $.ajax({
            url: `/news/news/${id}`,
            type: 'delete',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                if (data.code) {
                    return AdminBase.fail(data.msg || '删除失败');
                }
                location.href = '/news/news';
            }
        });
    }

    publish(id) {
        $.ajax({
            url: `/news/publish/${id}`,
            type: 'get',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                if (data.code) {
                    AdminBase.fail(data.msg || '发布失败')
                }
                location.href = '/news/news';
            }
        });
    }

    rollback(id) {
        $.ajax({
            url: `/news/publish/${id}?type=1`,
            type: 'get',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                if (data.code) {
                    AdminBase.fail(data.msg || '撤回失败')
                }
                location.href = '/news/news';
            }
        });
    }
});